<?php 
// TWEAKING THE EMAIL CAMPAIGN CPT LIST TABLE


// Customize the grid items custom post type table columns
function pcma_ecb_cpt_table_headings($columns) {
    $new_cols = array();

    $new_cols['cb']             = '<input type="checkbox" />';
    $new_cols['title']          = __('Internal title', PCMA_ML);
    $new_cols['ecb_title']      = __('E-mail title', PCMA_ML);
    $new_cols['ecb_template']   = __('Template', PCMA_ML);
    $new_cols['ecb_cats']       = __('Categories', PCMA_ML);
    $new_cols['ecb_status']     = __('Status');
    $new_cols['ecb_progress']   = __('Sending progress', PCMA_ML);
    $new_cols['date']           = __('Start/schedule date', PCMA_ML);

    return $new_cols;
}


function pcma_ecb_cpt_table_contents($column_name, $post_id) {
    $post = get_post($post_id);

    $assoc = array(
        'title'     => 'pcma_ecb_title',
        'template'  => 'pcma_ecb_template',
        'done'      => 'pcma_email_campaign_done',
        'paused'    => 'pcma_email_campaign_paused',

        'receivers'         => 'pcma_ecb_receivers', // array of user IDs
        'extra_user_ids'    => 'pcma_ecb_extra_user_ids', // array of extra user IDs
        'extra_emails'      => 'pcma_ecb_extra_emails', // array of extra e-mails

        'processed' => 'pcma_ecb_receivers_processed', // array (user_id (or extra_email) => timestamp) of processed receivers
        'failed'    => 'pcma_ecb_receivers_failed', // array (user_id (or extra_email) => reason) of failed submissions
    );
    $metas = pcma_email_campaigns::get_campaign_metas($post_id, $assoc);

    switch ($column_name) {
       case 'ecb_title' :
            
            echo $metas['title'];
            break;
        
            
        case 'ecb_template' :

            if(empty($metas['template'])) {
                echo '-';    
            }
            else {
                $term = get_term_by('id', $metas['template'], 'pcma_mail_templates');
                echo ($term) ? $term->name : '//';
            }
            break;
            
            
        case 'ecb_cats' :
            $cats = get_the_terms($post_id, 'pcma_email_cmp_cats');
            
            if(is_array($cats)) {
				$cmp_cats = array();
                
				foreach($cats as $cat) {
                    $cmp_cats[] = $cat->name;
                }
				echo implode(', ', $cmp_cats);
			}
			else {
                echo '-';
            }
            break;    


        case 'ecb_status' :

            if($post->post_status == 'draft') {
                echo '<span class="pcma_ecb_list_status" data-status="draft">'. __('draft') .'</span>';    
            }
            elseif($post->post_status == 'future' && empty($metas['processed'])) {
                echo '<span class="pcma_ecb_list_status" data-status="scheduled">'. __('scheduled') .'</span>';          
            }
            elseif(in_array($post->post_status, array('publish', 'trash')) || !empty($metas['processed'])) {

                // if WP failed to set campaign status - force it!
                if($post->post_status == 'future') {
                    global $wpdb;
                    $wpdb->query(
                        $wpdb->prepare("UPDATE ". $wpdb->posts ." SET post_status = '%s' WHERE ID = %d",
                            'publish',
                            $post_id
                        )
                    );
                }
                
                // show
                if($metas['done']) {
                    echo '<span class="pcma_ecb_list_status" data-status="completed">'. __('completed', PCMA_ML) .'</span>';    
                }
                elseif($metas['paused']) {
                    echo '<span class="pcma_ecb_list_status" data-status="paused">'. __('paused', PCMA_ML) .'</span>';
                }
                elseif($metas['processed']) {
                    echo '<span class="pcma_ecb_list_status" data-status="in_prog">'. __('in progress', PCMA_ML) .'</span>';
                }
                else {
                    echo '<span class="pcma_ecb_list_status" data-status="scheduled">'. __('scheduled') .'</span>';
                }
            }
            else {
                echo '-';    
            }

            break;


        case 'ecb_progress' :

            if(!in_array($post->post_status, array('publish', 'trash')) || empty($metas['processed'])) {
                echo '-';        
            }
            else {
                echo count($metas['processed']) .' '. __('on', PCMA_ML) .' '. count(pcma_email_campaigns::overall_receivers($metas['receivers'], $metas['extra_user_ids'], $metas['extra_emails'])) .' '. __('processed', PCMA_ML);   

                if(!empty($metas['failed'])) {
                    echo '<br/><strong>('. count($metas['failed']) .' '. __('failed', PCMA_ML) .')</strong>';    
                }
            }
            break;


        default:
            break;
    }
    return true;
}
add_filter('manage_edit-pcma_email_campaigns_columns', 'pcma_ecb_cpt_table_headings', 10);
add_action('manage_pcma_email_campaigns_posts_custom_column', 'pcma_ecb_cpt_table_contents', 10, 2);






// customize DATE column showing schedule or campaign start
function pcma_ecb_cpt_table_date_status($status, $post) {
    if($post->post_type != 'pcma_email_campaigns') {
        return $status;    
    }
    
    return '';
}
add_filter('post_date_column_status', 'pcma_ecb_cpt_table_date_status', 900, 2);



function pcma_ecb_cpt_table_date_time($time, $post) {
    if($post->post_type != 'pcma_email_campaigns') {
        return $time;    
    }
    
    $start_date = get_post_meta($post->ID, 'pcma_ecb_start_time', true);
    $txt = '';
    
    $txt .= (empty($start_date)) ? __('Scheduled for', PCMA_ML) : __('Started', PCMA_ML);
    $txt .= '<br/>';

    $target_date = (empty($metas['start_date'])) ? $post->post_date_gmt : $metas['start_date'];
    $txt .= get_date_from_gmt($target_date, 'Y/m/d') .' '. __('at') .' '. get_date_from_gmt($target_date, 'H:i');
    
    return $txt;
}
add_filter('post_date_column_time', 'pcma_ecb_cpt_table_date_time', 900, 2);






// replace "publish" filter with "running" and "completed"
// care also about scheduled, including WP "publish" but still not processed
function pcma_ecb_cpt_table_show_statuses_filter() {
    global $current_screen;
    
    if(!is_object($current_screen) || $current_screen->id != 'edit-pcma_email_campaigns') {
        return false;
    }
    dike_lc('lcweb', PCMA_DIKE_SLUG, true);
    
    
    $base_args = array(
        'post_type'     => 'pcma_email_campaigns', 
        'post_status'   => array('publish'), 
        'posts_per_page'=> -1, 
        'fields'        => 'ids',
        'meta_query'    => array(),
    );
    
    $counters = array('in_progress', 'completed', 'scheduled');
    $to_replace = array();
    
    foreach($counters as $key) {
        $args = $base_args;
        
        if($key == 'in_progress') {
            $args['meta_query'] = array(
                'relation' => 'AND',
                array(
                    'key'       => 'pcma_ecb_start_time',
                    'compare'   => 'EXISTS'
                ),
                array(
                    'key'       => 'pcma_email_campaign_done',
                    'compare'   => 'NOT EXISTS'
                ),
            );             
        }
        
        elseif($key == 'completed') {
            $args['meta_query'] = array(
                array(
                    'key'       => 'pcma_email_campaign_done',
                    'compare'   => 'EXISTS'
                ),
            );        
        }
        
        elseif($key == 'scheduled') {
            $args['post_status'] = array('publish', 'future');
            $args['meta_query'] = array(
                array(
                    'key'       => 'pcma_ecb_start_time',
                    'compare'   => 'NOT EXISTS'
                ),
            );        
        }
        
        
        $GLOBALS['pcma_ecb_cpt_table_query'] = true; // avoid the pre_get_posts filter
            
        $query = new WP_Query($args);
        $count = $query->found_posts;
        
        unset($GLOBALS['pcma_ecb_cpt_table_query']);
        
        if($count) {
            switch($key) {
                
                case 'in_progress' :
                    $name = __('In progress', PCMA_ML);
                    $addit_class = 'pcma_ecb_cs_in_prog';    
                    break;
                    
                case 'completed' :
                    $name = __('Completed', PCMA_ML);
                    $addit_class = 'pcma_ecb_cs_completed';
                    break;
                    
                case 'scheduled' :
                    $name = __('Scheduled');
                    $addit_class = 'pcma_ecb_cs_scheduled';
                    break;  
            }

            $current    = (isset($_GET['post_status']) && $_GET['post_status'] == $key) ? 'current' : '';
            
            $to_replace[$key] = '<a href="edit.php?post_status='. $key .'&post_type=pcma_email_campaigns" class="'. $current .' '. $addit_class .'">'. $name .' <span class="count">('. $count .')</span></a>';    
        }
    }
    
    ?>
    <script type="text/javascript">
    (function($) { 
        "use strict";
        
        const $target_filter = (document.querySelector('.subsubsub .publish')) ? document.querySelector('.subsubsub .publish') : document.querySelector('.subsubsub .all');
        if(document.querySelector('.subsubsub .future')) {
            document.querySelector('.subsubsub .future').remove();        
        }
        
        if($target_filter) {
            const separator = (document.querySelectorAll('.subsubsub li').length > 2) ? ' |' : '';
            
            <?php foreach($to_replace as $key => $contents) : ?>
                $target_filter.insertAdjacentHTML('afterend', `<li class="pcma_ecb_status <?php echo $key ?>"><?php echo $contents ?>${ separator }</li>`);
            <?php endforeach; ?>
            
            if(document.querySelector('.subsubsub .publish')) {
                $target_filter.remove();
            }
        }
        
        
        
        <?php
        // if has campaigns in progress - output warning about next sending time
        ?>
        
        <?php
        $esipp_warning = pcma_email_campaigns::get_esipp_warning();
        if($esipp_warning) {
            pcma_email_campaigns::sent_emails_counter_reset_js_code();    
        }
    
        if(!pcma_email_campaigns::can_send_emails()) :
        ?>
            document.querySelector('.screen-reader-text').insertAdjacentHTML('beforebegin', `
                <div class="notice notice-error">
                    <p><?php echo $esipp_warning ?></p>
                </div>`); 
        
        <?php
        else :
            $next_scheduled_sending_time = wp_next_scheduled('pcma_process_campaigns'); 
            $next_scheduled_sending = get_date_from_gmt(date('Y-m-d H:i:s', $next_scheduled_sending_time), 'H:i');
    
            if($esipp_warning) :
            ?>
                document.querySelector('.screen-reader-text').insertAdjacentHTML('beforebegin', `
                <div class="notice notice-warning">
                    <p><?php echo $esipp_warning ?></p>
                </div>`);
            <?php endif; ?>

            if(document.querySelector('.pcma_ecb_cs_in_prog')) {
                document.querySelector('.screen-reader-text').insertAdjacentHTML('beforebegin', `
                    <div class="notice notice-warning">
                        <p>
                            <?php echo __("Next scheduled sending at", PCMA_ML) .' '. $next_scheduled_sending ?> 
                            <a href="javascript:void(0)" class="page-title-action pcma_process_ecb_now"><?php esc_attr_e('run now', PCMA_ML) ?></a>
                        </p>
                    </div>`);


                // process "run now" command
                $(document).on('click', '.pcma_process_ecb_now', function() {
                    window.location.href = '<?php echo (isset($_GET['pcma_process_campaigns'])) ? pc_static::curr_url() : pc_static::curr_url() .'&pcma_process_campaigns' ?>';    
                });
            }
        <?php 
        endif;



        // if "run now" parameter is in the URL - remove it!
        if(isset($_GET['pcma_process_campaigns'])) :
        ?>
            window.history.replaceState(null, null, "<?php echo str_replace('&pcma_process_campaigns', '', pc_static::curr_url()) ?>");
        <?php
        endif; 
        ?>
    })(jQuery);    
    </script>
    <?php
}
add_action('admin_footer', 'pcma_ecb_cpt_table_show_statuses_filter');




// filter by campaign status
function pcma_ecb_cpt_table_perform_statuses_filter($query) {
    global $current_screen, $post_type; 
    
    if(
        isset($GLOBALS['pcma_ecb_cpt_table_query']) ||
        !is_object($current_screen) || $current_screen->id != 'edit-pcma_email_campaigns' || 
        !isset($_GET['post_status']) || !in_array($_GET['post_status'], array('completed', 'in_progress', 'scheduled'))
    ) {
        return false;    
    }
        
    
    if($_GET['post_status'] == 'completed') {
    
        $meta_query = array(
            array(
                'key'       => 'pcma_email_campaign_done',
                'compare'   => 'EXISTS'
            )
        );
        $query->set('post_status', array('publish'));
    }

    elseif($_GET['post_status'] == 'in_progress') {
        
        $meta_query = array(
            'relation' => 'AND',
            array(
                'key'       => 'pcma_ecb_start_time',
                'compare'   => 'EXISTS'
            ),
            array(
                'key'       => 'pcma_email_campaign_done',
                'compare'   => 'NOT EXISTS'
            ),
        );   
        $query->set('post_status', array('publish'));
    }
    
    elseif($_GET['post_status'] == 'scheduled') {
        
        $meta_query = array(
            array(
                'key'       => 'pcma_ecb_start_time',
                'compare'   => 'NOT EXISTS'
            ),
        );    
        $query->set('post_status', array('publish', 'future'));
    }
    
    $query->set('meta_query', $meta_query);
}
add_action('pre_get_posts', 'pcma_ecb_cpt_table_perform_statuses_filter');






// add "clone" in action row
function pcma_ecb_cpt_table_add_clone_link($actions, $post) {
    if($post->post_type != 'pcma_email_campaigns') {
        return $actions;    
    }
    
    $new_action = array('pcma_ecb_clone' => '<a href="javascript:void(0)" class="pcma_ecb_clone_cmp" data-cmp-id="'. $post->ID .'">'. __('Clone', PCMA_ML) .'</a>');
    return array_merge($new_action, $actions);
}
add_filter('post_row_actions', 'pcma_ecb_cpt_table_add_clone_link', 100, 2);




// JS cde to perform the clone
function pcma_ecb_cpt_table_clone_js_code() {
    global $current_screen; 
    
    if(!is_object($current_screen) || $current_screen->id != 'edit-pcma_email_campaigns') {
        return false;    
    }

    ?>
    <script type="text/javascript">
    (function($) { 
        "use strict";
        
        $(document).ready(function() {
            <?php pcma_email_campaigns::campaign_clone_js_code() ?>        
        });
    })(jQuery);    
    </script>    
    <?php
}
add_action('admin_footer', 'pcma_ecb_cpt_table_clone_js_code');






// enable cmp category filter
function pcma_ecb_cpt_table_cat_filter() {
    global $typenow, $wp_query;
    
    if(!$typenow || $typenow != 'pcma_email_campaigns') {
        return false;    
    }
	
    
    $tax_name = 'pcma_email_cmp_cats';
    $sel = (isset($wp_query->query[$tax_name])) ? $wp_query->query[$tax_name] : ''; 

    wp_dropdown_categories(array(
        'show_option_all' =>  __("Any category", PCMA_ML),
        'taxonomy'        =>  $tax_name,
        'name'            =>  $tax_name,
        'orderby'         =>  'name',
        'selected'        =>  $sel,
        'hierarchical'    =>  true,
        'depth'           =>  1,
        'show_count'      =>  false,
        'hide_empty'      =>  true
    ));
}
add_action('restrict_manage_posts', 'pcma_ecb_cpt_table_cat_filter');



function pcma_ecb_cpt_table_cat_id_to_term($query) {
	global $pagenow;
	
	$post_type = 'pcma_email_campaigns';
	$taxonomy  = 'pcma_email_cmp_cats';
	
	$q_vars    = &$query->query_vars;
	if(
        $pagenow == 'edit.php' && isset($q_vars['post_type']) && $q_vars['post_type'] == $post_type && 
        isset($q_vars[$taxonomy]) && is_numeric($q_vars[$taxonomy]) && $q_vars[$taxonomy]
    ) {
		
		$term = get_term_by('id', $q_vars[$taxonomy], $taxonomy);
		$q_vars[$taxonomy] = $term->slug;
	}
}
add_filter('parse_query', 'pcma_ecb_cpt_table_cat_id_to_term', 999);






// filtering shown campaigns for "PvtConent admin" users
function pcma_ecb_filter_where_query_for_pc_admins($where) {
    global $typenow, $wpdb;
    
    if(!$typenow || $typenow != 'pcma_email_campaigns') {
        return $where;    
    }
    
    $prevented_cats = pc_wpuc_static::get_wp_user_prevented_pc_cats();
    if(empty($prevented_cats)) {
        return $where;    
    }
    
    
    add_filter('posts_join', 'pcma_ecb_filter_join_query_for_pc_admins', 9999);
    add_action('admin_head', 'pcma_ecb_hide_cmp_counts_for_pc_admins');
    
    foreach($prevented_cats as $cat_id) {
        $where .= " AND (". $wpdb->postmeta.".meta_key = 'pcma_ecb_receivers' AND ". $wpdb->postmeta .".meta_value NOT LIKE '%\:\"". (int)$cat_id ."\"\;%')";
    }
    
    return $where;
}
add_filter('posts_where', 'pcma_ecb_filter_where_query_for_pc_admins', 100);



function pcma_ecb_filter_join_query_for_pc_admins($join) {
    global $wp_query, $wpdb;

    if(strpos($join, "JOIN ". $wpdb->postmeta) === false) {
        $join .= "INNER JOIN ". $wpdb->postmeta ." ON ". $wpdb->posts .".ID = ". $wpdb->postmeta .".post_id ";
    }
    
    return $join;
}


function pcma_ecb_hide_cmp_counts_for_pc_admins() {
    ?>
    <style>.subsubsub .count { display: none !important;}</style>
    <?php
}
